package GraphicThreads;

import UI.MyPane;
import javafx.application.Platform;
import Back.Tree;
import Back.Node;

import java.io.Serializable;

public class JoinThread<T extends Serializable & Comparable<T> > extends GraphicThread {
    Tree<T> tree2;
    /**
     * konstruktor, pradi pane
     * @param _pane
     */
    public JoinThread(MyPane _pane) {
        pane = _pane;
        tree = pane.getTree1();
        tree2 = pane.getTree2();
        SLEEP_TIME = 1000;
    }


    /**
     * spustac threadu
     * zavola funkciu threadJoin ktora spaja korene stromov
     * ak sa koren druheho nenachadza v prvom skusi to naopak
     *
     * po skonceni vypise hotovo vykresli finalny strom1
     */
    public void run() {
        if (! threadJoin(tree.getRoot(),tree2.getRoot())){
            if ( threadJoin(tree2.getRoot(),tree.getRoot())){
                tree.setRoot(tree2.getRoot());
            }
        }
        //System.out.println("Hotovo");

        Platform.runLater(() -> {
            pane.end();
        });

    }


    /**
     * prerobena funkcia Ostatne.Node.Join
     * hlada ci sa find nachadza v podstrome node
     * ak ho najde pridava pomocou prisposobenej funkcie add
     * ak nie vracia false
     * @param find koren ktory sa pridava
     * @param node koren do ktoreho sa pridava
     * @return skusi pridat find do node, ak sa podari vrati true inac false
     */
    public boolean threadJoin(Node<T> node, Node<T> find ){

        Node<T> where = threadFindByNode(node, find);
        if ( where == null) return false;

        threadAdd( where, find);
        return true;

    }
}